<?php
// current subversion revision
if (file_exists('cache/svnrev.php'))
{
	include('cache/svnrev.php');
}
else
{
	$svn_rev = '445';
}
define('SVN_REV', $svn_rev);

define('LASTEST_DB_UPDATE',"011");

// current version: major.minor.sub
// unpair numbers for minor = development version
define('KB_VERSION', '2.0.3');
define('KB_RELEASE', '(Apocrypha)');

// set the running-server for id-syncs here
define('KB_SYNCURL', 'http://sync.eve-dev.net/?a=sync_server');

// add new corporations here once you've added the logo to img/corps/
$corp_npc = array('Guristas', 'Serpentis Corporation', 'Sansha\'s Nation', 'CONCORD',
	'Mordus Legion', 'Blood Raider', 'Archangels', 'Guardian Angels', 'True Power');

function shorten($shorten, $by = 22)
{
	if (strlen($shorten) > $by)
	{
		$s = substr($shorten, 0, $by) . "...";
	}
	else $s = $shorten;

	return $s;
}

function slashfix($fix)
{
	return addslashes(stripslashes($fix));
}

function roundsec($sec)
{
	if ($sec <= 0)
		$s = 0.0;
	else
		$s = $sec;

	return number_format(round($s, 1), 1);
}
//! Check if a version of this template for the igb exists and return that if so.
function get_tpl($name)
{
	if (IS_IGB)
	{
		if (file_exists('./templates/igb_'.$name.'.tpl'))
		{
			return 'igb_'.$name.'.tpl';
		}
	}
	return $name.'.tpl';
}

// this is currently only a wrapper but might get
// timestamp adjustment options in the future
function kbdate($format, $timestamp = null)
{
	if ($timestamp === null)
	{
		$timestamp = time();
	}

	if (config::get('date_gmtime'))
	{
		return gmdate($format, $timestamp);
	}
	return date($format, $timestamp);
}

function getYear()
{
	$test = kbdate('o');
	if ($test == 'o')
	{
		$test = kbdate('Y');
	}
	return $test;
}

//! Return start date for the given week, month, year or date.

/*!
 * weekno > monthno > startWeek > yearno
 * weekno > monthno > yearno
 * startDate and endDate are used if they restrict the date range further
 * monthno, weekno and startweek are not used if no year is set
 */
function makeStartDate($week = 0, $year = 0, $month = 0, $startweek = 0, $startdate = 0)
{
		$qstartdate=0;
		if(intval($year)>0)
		{
			if($week)
			{
				if ($week == 1)
					{$qstartdate = strtotime($year.'-1-1 00:00 UTC');}
				else
					{$qstartdate = strtotime('last Monday +'.($week-1).' weeks UTC', strtotime($year.'-1-1'));}
			}
			else if($month)
				{$qstartdate = strtotime($year.'-'.$month.'-1 00:00 UTC');}
			else if($startweek)
			{
				if ($startweek == 1) {$qstartdate = strtotime($year.'-1-1 00:00 UTC');}
				else{$qstartdate = strtotime('last Monday +'.($week-1).' weeks UTC', strtotime($year.'-1-1'));}
			}
			else
				{$qstartdate = strtotime($year.'-1-1 00:00 UTC');}
		}
		//If set use the latest startdate and earliest enddate set.
		if($startdate && $qstartdate < strtotime($startdate." UTC")) $qstartdate = strtotime($startdate." UTC");
		return $qstartdate;
}

//! Return end date for the given week, month, year or date.

/*!
 *  Priority order of date filters:
 * weekno > monthno > startWeek > yearno
 * weekno > monthno > yearno
 * startDate and endDate are used if they restrict the date range further
 * monthno, weekno and startweek are not used if no year is set
 */
function makeEndDate($week = 0, $year = 0, $month = 0, $enddate = 0)
{
		if($year)
		{
			if($week)
			{
				if ($week == 53)
					$qenddate = strtotime(($year).'-12-31 23:59 UTC');
				else
					$qenddate = strtotime('last Monday +'.($week).' weeks -1 minute UTC', strtotime($year.'-1-1'));
			}
			else if($month)
			{
				if($month == 12) $qenddate = strtotime(($year).'-12-31 23:59 UTC');
				else $qenddate = strtotime(($year).'-'.($month + 1).'-1 00:00 - 1 minute UTC');
			}
			else
				$qenddate = strtotime(($year).'-12-31 23:59 UTC');
		}
		//If set use the earliest enddate.
		if($enddate && (!$qenddate || ($qenddate && $qenddate > strtotime($enddate." UTC")))) $qenddate = strtotime($enddate." UTC");

		return $qenddate;
}
